
DROP VIEW public.v_cupomfiscal_item_receita;

CREATE OR REPLACE VIEW public.v_cupomfiscal_item_receita
AS SELECT pdv_vd_it.cd_emp,
    pdv_vd_it.cd_filial,
    pdv_vd_it.cd_vd,
    pdv_vd_it.cd_it,
    COALESCE(pdv_vd_it.cd_medico_rec, vdit.cd_medico_rec::numeric) AS prescritor_id,
    COALESCE(pdv_vd_it.nr_receita, vdit.nr_receita::bigint) AS receita_numero,
        CASE
            WHEN date_part('day'::text, min(pdv_vd_it.dt_receita)) > 0::double precision THEN pdv_vd_it.dt_receita
            WHEN date_part('day'::text, min(vdit.dt_receita)) > 0::double precision THEN vdit.dt_receita
            ELSE 'now'::text::date::timestamp without time zone
        END AS receita_data,
        CASE
            WHEN pdv_vd_it.nm_comprador_receita::text <> ''::text THEN pdv_vd_it.nm_comprador_receita
            WHEN vdit.nm_comprador::text <> ''::text THEN vdit.nm_comprador
            ELSE ''::character varying
        END AS comprador_nome,
        CASE
            WHEN pdv_vd_it.nr_doc_cli_receita::text <> ''::text THEN pdv_vd_it.nr_doc_cli_receita
            WHEN vdit.nr_doc_cli::text <> ''::text THEN vdit.nr_doc_cli
            ELSE ''::character varying
        END AS comprador_doc_numero,
    COALESCE(pdv_vd_it.tp_doc_cli_receita, vdit.tipo_documento) AS comprador_doc_tipo,
    COALESCE(vdit.tp_doc_exp, 0) AS comprador_doc_expedidor,
        CASE
            WHEN pdv_vd_it.uf_receita::text <> ''::text THEN pdv_vd_it.uf_receita
            WHEN vdit.uf::text <> ''::text THEN vdit.uf
            ELSE ''::character varying
        END AS comprador_doc_uf,
    COALESCE(vdit.cid, 0) AS paciente_cid,
    COALESCE(pdv_vd_it.idade_receita, vdit.idade) AS paciente_idade,
        CASE
            WHEN pdv_vd_it.nm_paciente_receita::text <> ''::text THEN pdv_vd_it.nm_paciente_receita
            WHEN vdit.nm_paciente::text <> ''::text THEN vdit.nm_paciente
            ELSE ''::character varying
        END AS paciente_nome,
    COALESCE(vdit.sexo, 0) AS paciente_sexo,
    0 AS paciente_tipo_idade
   FROM pdv_vd_it
     JOIN pdv_vd vd ON vd.cd_emp = pdv_vd_it.cd_emp AND vd.cd_filial = pdv_vd_it.cd_filial AND vd.cd_vd = pdv_vd_it.cd_vd
     LEFT JOIN pdv_vd_it_rec vdit ON pdv_vd_it.cd_emp = vdit.cd_emp 
							     AND pdv_vd_it.cd_filial = vdit.cd_filial 
								 AND pdv_vd_it.cd_prod = vdit.cd_prod 
								 AND pdv_vd_it.cd_vd = vdit.cd_vd
								 and pdv_vd_it.cd_it = vdit.cd_it 
	 
  WHERE COALESCE(pdv_vd_it.cd_receita, vdit.cd_receita) > 0 AND vd.st_vd > '-1'::integer::numeric
  GROUP BY pdv_vd_it.cd_emp, pdv_vd_it.cd_filial, pdv_vd_it.cd_vd, pdv_vd_it.cd_it, vdit.cd_medico_rec, vdit.nr_receita, vdit.dt_receita, vdit.nm_comprador, vdit.nr_doc_cli, vdit.tipo_documento, vdit.tp_doc_exp, vdit.uf, vdit.cid, vdit.idade, vdit.nm_paciente, vdit.sexo
UNION
 SELECT orc.cd_emp,
    orc.cd_filial,
    vd.cd_vd,
    it.cd_it,
    COALESCE(orc.cd_medico_rec, 0) AS prescritor_id,
    COALESCE(orc.nr_receita, 0::bigint) AS receita_numero,
    COALESCE(orc.dt_receita, 'now'::text::date::timestamp without time zone) AS receita_data,
    COALESCE(orc.nm_comprador, NULL::character varying) AS comprador_nome,
    COALESCE(orc.nr_doc_cli, NULL::character varying) AS comprador_doc_numero,
    COALESCE(orc.tipo_documento, NULL::integer) AS comprador_doc_tipo,
    COALESCE(orc.tp_doc_exp, NULL::integer) AS comprador_doc_expedidor,
    COALESCE(orc.uf, NULL::character varying) AS comprador_doc_uf,
    NULL::integer AS paciente_cid,
    COALESCE(orc.idade, NULL::integer) AS paciente_idade,
    COALESCE(orc.nm_paciente, NULL::character varying) AS paciente_nome,
    COALESCE(orc.sexo, NULL::integer) AS paciente_sexo,
    0 AS paciente_tipo_idade
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
     JOIN est_orc_glb_medico orc ON it.cd_emp    = orc.cd_emp::numeric 
     							AND it.cd_filial = orc.cd_filial::numeric 
     							AND vd.nr_orc    = orc.nr_orc::numeric 
     							AND it.cd_prod   = orc.cd_prod::numeric
     							and it.cd_it 	 = orc.cd_it::numeric
  WHERE COALESCE(it.cd_receita, 0) = 0 AND vd.st_vd > '-1'::integer::numeric
  ORDER BY 1, 2, 3, 4;
